		function [G, Z, P] = BW_POLES_HB_Z(wsT, Amin, N)	
		
		% 	Computes the poles, zeros, and gain constant for a digital
		%	half-band Butterworth filter.
		
		% 	Toolbox for DIGITAL FILTERS USING MATLAB
		
		% 	Author: 		Lars Wanhammar, 2001-10-08
		% 	Modified by: 	
		% 	Version: 		1
		% 	Copyright:		by authors - not released for commercial use
		% 	Known bugs:		 		
		% 	Report bugs to:	Wanhammar@gmail.com
		
		% N must be an odd integer
		if ~(abs(N-round(N)) < eps)
			error('N must be an integeer')  
			return
		end
		if mod(N, 2) == 0 | N < 3
			disp([' Error  The filer order must be odd'])
			return
		end	
		Eps_s = sqrt(10^(0.1*Amin) - 1);
		Eps_p = 1/Eps_s;
		Amax = 10*log10(1 + Eps_p^2);
		Omega_s = tan(wsT/2);
		Omega_p = tan((pi-wsT)/2);
		[Ga, Za, Pa] = BW_POLES_S(Omega_p, Omega_s, Amax, Amin, N);	
		[G, Z, P] = PZ_2_PZ_Z(Ga, Za, Pa, 2);
		P = i*imag(P);	% Force the poles onto the imginary axis
		P(1) = 0;
		G = 1/real(prod(1-Z)/prod(1-P));	% Normalize the gain again
		
		
